import discord

from discord.ext import commands

import json

# Charger la config

with open("config.json") as f:

    config = json.load(f)

WELCOME_CHANNEL_ID = config["WELCOME_CHANNEL_ID"]

FOOTER_TEXT = config["FOOTER_TEXT"]

FOOTER_ICON = config["FOOTER_ICON"]

class Welcome(commands.Cog):

    def __init__(self, bot):

        self.bot = bot

    @commands.Cog.listener()

    async def on_member_join(self, member: discord.Member):

        salon_bienvenue = self.bot.get_channel(WELCOME_CHANNEL_ID)

        if salon_bienvenue is None:

            return

        embed = discord.Embed(

            title="🎉 Bienvenue !",

            description=f"Bienvenue {member.mention} sur **{member.guild.name}** !\n\nNous sommes heureux de t'accueillir 😊",

            color=0x00FF00

        )

        embed.set_footer(text=FOOTER_TEXT, icon_url=FOOTER_ICON)

        await salon_bienvenue.send(embed=embed)

async def setup(bot):

    await bot.add_cog(Welcome(bot))